/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.crypto;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractProxyVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.crypto.CryptoEngine;
import jpcsp.crypto.PGD;
import jpcsp.util.Utilities;

public class PGDBlockVirtualFile
extends AbstractProxyVirtualFile {
    private static final int pgdHeaderSize = 144;
    private byte[] key;
    private int dataOffset;
    private int dataSize;
    private int blockSize;
    private boolean headerValid;
    private boolean headerPresent;
    private byte[] buffer;
    private byte[] header;
    private PGD pgd;
    private boolean sequentialRead;

    public PGDBlockVirtualFile(IVirtualFile pgdFile, byte[] key, int dataOffset) {
        super(pgdFile);
        if (key != null) {
            this.key = (byte[])key.clone();
        }
        this.dataOffset = dataOffset;
        super.ioLseek(dataOffset);
        this.pgd = new CryptoEngine().getPGDEngine();
        this.readHeader();
        this.dataOffset += dataOffset;
    }

    private void readHeader() {
        this.headerValid = false;
        this.headerPresent = false;
        byte[] inBuf = new byte[144];
        super.ioRead(inBuf, 0, 144);
        int magic = Utilities.readUnaligned32(inBuf, 0);
        if (magic != 1145524224) {
            log.warn((Object)String.format("No PGD header detected 0x%08X ('%c%c%c%c') detected in file '%s'", magic, Character.valueOf((char)inBuf[0]), Character.valueOf((char)inBuf[1]), Character.valueOf((char)inBuf[2]), Character.valueOf((char)inBuf[3]), this.vFile));
            return;
        }
        this.headerPresent = true;
        byte[] headerBuf = new byte[64];
        System.arraycopy(inBuf, 16, headerBuf, 0, 16);
        System.arraycopy(inBuf, 48, headerBuf, 16, 48);
        if (this.key == null) {
            this.key = this.pgd.GetEDATPGDKey(inBuf, 144);
        }
        this.header = this.pgd.DecryptPGD(headerBuf, headerBuf.length, this.key, 0);
        IntBuffer decryptedHeader = ByteBuffer.wrap(this.header).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        this.dataSize = decryptedHeader.get(5);
        this.blockSize = decryptedHeader.get(6);
        this.dataOffset = decryptedHeader.get(7);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("PGD dataSize=%d, blockSize=%d, dataOffset=%d", this.dataSize, this.blockSize, this.dataOffset));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("PGD Header: %s", Utilities.getMemoryDump(inBuf, 0, 144)));
                log.trace((Object)String.format("Decrypted PGD Header: %s", Utilities.getMemoryDump(this.header, 0, this.header.length)));
            }
        }
        if (this.dataOffset < 0 || (long)this.dataOffset > super.length() || this.dataSize < 0) {
            log.warn((Object)String.format("Incorrect PGD header: dataSize=%d, chunkSize=%d, hashOffset=%d", this.dataSize, this.blockSize, this.dataOffset));
            return;
        }
        this.buffer = new byte[this.blockSize + 16];
        this.headerValid = true;
        this.sequentialRead = false;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public boolean isHeaderValid() {
        return this.headerValid;
    }

    public boolean isHeaderPresent() {
        return this.headerPresent;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        byte[] decryptedBytes;
        int seed = 0;
        if (!this.sequentialRead) {
            seed = (int)(this.getPosition() >> 4);
        }
        int readLength = this.blockSize;
        super.ioRead(this.buffer, 16, readLength);
        System.arraycopy(this.header, 0, this.buffer, 0, 16);
        if (this.sequentialRead) {
            decryptedBytes = this.pgd.UpdatePGDCipher(this.buffer, readLength + 16);
        } else {
            this.pgd.FinishPGDCipher();
            decryptedBytes = this.pgd.DecryptPGD(this.buffer, readLength + 16, this.key, seed);
            this.sequentialRead = true;
        }
        int length = Math.min(outputLength, decryptedBytes.length);
        System.arraycopy(decryptedBytes, 0, outputBuffer, outputOffset, length);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("PGDBlockVirtualFile.ioRead length=0x%X: %s", length, Utilities.getMemoryDump(decryptedBytes, 0, length)));
        }
        return length;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        return this.ioReadBuf(outputPointer, outputLength);
    }

    @Override
    public long ioLseek(long offset) {
        long result = super.ioLseek((long)this.dataOffset + offset);
        if (result >= 0L && result >= (long)this.dataOffset) {
            result -= (long)this.dataOffset;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("PGDBlockVirtualFile.ioLseek offset=0x%X, result=0x%X", offset, result));
        }
        this.sequentialRead = false;
        return result;
    }

    @Override
    public long getPosition() {
        long position = super.getPosition();
        if (position >= 0L && position >= (long)this.dataOffset) {
            position -= (long)this.dataOffset;
        }
        return position;
    }

    @Override
    public long length() {
        return this.dataSize;
    }
}

